/*
 * EObject.h
 *
 *  Created on: Jun 25, 2014
 *      Author: Daniel Wesierski
 */

#include "part.h"

cv::Mat Part::compute_hist(const cv::Mat& image, const cv::Rect& roi, unsigned int nBins)
{
	unsigned int dim = nBins*nBins*nBins;
	cv::Mat histogram(dim,1,CV_32F,cv::Scalar(0));

	int res = 256/nBins;
	int c1 = nBins*nBins, c2 = nBins;

	float* histogramPtr = (float*) histogram.data;

	for (int i=roi.y; i != roi.y+roi.height; ++i)
	{
		for (int j=roi.x; j != roi.x+roi.width; ++j)
		{
			const cv::Vec3b& pix = image.at<cv::Vec3b>(i,j);
			histogramPtr[c1*(pix[0]/res) + c2*(pix[1]/res) + pix[2]/res] += 1.0;
		}
	}

	// normalize histogram
	int scale = roi.area();
	histogramPtr = (float*) histogram.data;
	for (int i=0; i != histogram.rows; ++i)
		histogramPtr[i] /= scale;

	return histogram;
}

cv::Point2d BBox::get_center()
{
	cv::Point2d center;
	center.x = 0.5*(bbox.tl().x + bbox.br().x);
	center.y = 0.5*(bbox.tl().y + bbox.br().y);
	return center;
}

cv::Mat BBox::get_patch(const cv::Mat& image)
{
	return image(bbox);
}

void BBox::draw(cv::Mat image,
			    cv::Scalar color,
			    int lineWidth,
			    int lineType)
{
	cv::rectangle(image, bbox, color, lineWidth, lineType);
}

