#include <opencv2\highgui.hpp>
#include "configuration.h"
#include "tracker.h"


#define IIR_COEFF					0.1    // IIR forgetting factor
#define HIST_BINS					8      // num of bins per color histogram axis
#define APP_VAR 					2.0    // appearance std dev
#define ANG_VAR						60.0   // angular std dev
#define GRID_DELTA_PLANE			1.0/4  // num of samples per part width/height
#define GRID_SIZE_PLANE				2.0    // size of search grid
#define GRID_DELTA_SCALE 			1.0/10 // diff between scale sizes
#define GRID_SIZE_SCALES			1      // num of scales

int main( int argc, char** argv )
{	
	Config conf(GRID_DELTA_PLANE, GRID_SIZE_PLANE, GRID_SIZE_SCALES, GRID_DELTA_SCALE, IIR_COEFF, APP_VAR, ANG_VAR, HIST_BINS); // set xml file path
	// init tracker object
	Tracker t(conf);
	// and track
	t.run();
	return 0;
}
