/*
 * Tracker.h
 *
 *  Created on: Jun 29, 2014
 *      Author: danwes
 */

#ifndef TRACKER_H_
#define TRACKER_H_

#include "part.h"
#include "eobject.h"
#include "configuration.h"
#include <opencv2/highgui.hpp>


class Tracker
{
	typedef std::vector<std::vector<BBox*> > vecVecBBoxPtr;

public:

	Tracker(Config& conf)
		: cap(conf.capture), coeffIIR(conf.iirCoeff) {
		cv::Mat image;
		cap >> image;
		eo = EObject(image, conf);
		canEOs.resize(eo.parts.size());
		app.resize(eo.parts.size());
		def.resize(eo.parts.size() - 1);
		ptr.resize(eo.parts.size() - 1);
		bestCansIdx.resize(eo.parts.size());
		bestEO.resize(eo.parts.size());
		writeframeresult();
	};

	double bhattacharyya_score(const cv::Mat& hist1, const cv::Mat& hist2);
	double chisquare_score(const cv::Mat& hist1, const cv::Mat& hist2);

	void run();
	void detect(const cv::Mat& image);
	void update(int imW, int imH);
	void gen_candidates();
	void build_graph(const cv::Mat& image);
	void infer();
	void pass_msg();
	void backtrack();
	void clear();
	void update_scale();
	void update_orientation();
	void update_location(int imW, int imH);
	void writeframeresult();

	cv::Mat Kabsch(cv::Mat& p, cv::Mat& q);

	void draw_grid(cv::Mat image, unsigned int d = 0);

private:
	EObject eo;
	vecVecBBoxPtr canEOs;
	cv::VideoCapture cap;
	double coeffIIR;
	std::vector<std::vector<double> > app;
	std::vector<std::vector<double> > def;
	std::vector<std::vector<int> > ptr;
	std::vector<int> bestCansIdx;
	std::vector<BBox> bestEO;
	std::vector<std::vector<double> > result;
};


#endif /* TRACKER_H_ */

