/*
 * Part.h
 *
 *  Created on: Jun 25, 2014
 *      Author: Daniel Wesierski
 */

#ifndef PART_H_
#define PART_H_

#include <opencv/cv.hpp>

class BBox {
public:

	BBox(){ };

	BBox(const cv::Rect& roi) {
		bbox = roi;
		center = get_center();
	};

	cv::Point2d get_center();
	cv::Mat get_patch(const cv::Mat& image);
	void draw(cv::Mat image, cv::Scalar color, int lineWidth, int lineType=8);

	cv::Rect_<double> bbox;
	cv::Point2d center;	
};


class Part : public BBox
{
public:
	Part(const cv::Mat& image, const cv::Rect& roi, unsigned int nBins) {
		bbox = roi;
		hist = compute_hist(image, bbox, nBins);
		center = get_center();
	};

	cv::Mat compute_hist(const cv::Mat& image, const cv::Rect& roi, unsigned int nBins);
	cv::Mat hist;		// model appearance of part
};


#endif /* PART_H_ */
