/*
 * configuration.h
 *
 *  Created on: Jul 8, 2014
 *      Author: Daniel Wesierski
 */

#ifndef CONFIGURATION_H_
#define CONFIGURATION_H_

#include "helpers.h"
#include <opencv2/highgui.hpp>
#include <opencv2/opencv.hpp>

class Config {
public:

	Config(double p1, double p2, int p3, double p4, double p5, double p6, double p7, unsigned int p8)
	: gridResolution(p1), gridSz(p2), scaleNum(p3), stepScales(p4), iirCoeff(p5), appearanceVar(p6), angularVar(p7), histNBins(p8) {

		std::string pathtovideo;		
		parseconfigfile("config.txt", pathtovideo, initBboxes, partsIdx);
		capture = cv::VideoCapture(pathtovideo);			

		// ensure input parameters satisfy conditions
		if (histNBins < 2 || histNBins > 256) histNBins = 8;
		if (gridResolution > 1) gridResolution = 1/4;
		if (gridSz < 0) gridSz = 2;
		scaleNum = std::max(1,scaleNum);
		if (scaleNum%2==0) scaleNum = abs(scaleNum)+1;
		if (stepScales <= 0 || stepScales > 0.5) stepScales = 0.1;
		if (iirCoeff < 0 || iirCoeff > 1) iirCoeff = 0.1;
		if (appearanceVar <= 0) appearanceVar = 2;
		if (angularVar <= 0 || angularVar > 180) angularVar = 60;
	}

	cv::VideoCapture capture;
	std::vector<cv::Rect> initBboxes; // annotated bboxes
	std::vector<std::vector<unsigned int> > partsIdx; // assignment of bboxes to segment ids
	double gridResolution;
	double gridSz;
	int scaleNum;
	double stepScales;
	double iirCoeff;
	double appearanceVar;
	double angularVar;
	unsigned int histNBins;
};

#endif /* CONFIGURATION_H_ */
