/*
	Vertex shader - przykad z OpenGL
	* jeden obiekt pokryty tekstur
	* owietlony jednym rdem wiata punktowego
	* model cieniowania Phonga		

	Program wykonywany jeden raz dla kadego wierzchoka siatki obiektu
	
	Opracowano na podstawie: http://ogldev.atspace.co.uk/www/tutorial20/tutorial20.html

*/

#version 330                                                                        
                                                                                    
// Parametry wejciowe przekazywane z gwnego programu

// Wartoci zmienne dla kadego wierzchoka :
// wsprzdne wierzchoka w uk. wsp. modelu:
layout (location = 0) in vec3 Position;                                             
// wsprzdne tekstury:
layout (location = 1) in vec2 TexCoord;
// wsprzdne wektora normalnego do wierzchoka w uk. wsp. modelu:                                            
layout (location = 2) in vec3 Normal;                                               
                                                                                    
// Wartoci wejciowe stae (uniform)
// macierz przeksztacenia wierzchoka:
//   W - world - z uk. modelu do uk. wiata (skalowanie, obrt, przesunicie)
//   V - view - z uk. wiata do uk. widoku
//   P - perspective - rzutowanie perspektywiczne
uniform mat4 gWVP;
// macierz przeksztacenia z uk. obiektu do uk. wiata:                                                                  
uniform mat4 gWorld;                                                                
 
                                                                                    
// Wartoci wyjciowe shadera - przekazywane do fragment shadera
// wsprzdne tekstury
out vec2 TexCoord0;
// wsprzdne wektora normalnego w uk. wsp. wiata:                                                                 
out vec3 Normal0; 
// wsprzdne wierzchoka w uk. wsp. wiata:                                                                  
out vec3 WorldPos0;
// wsprzdne wierzchoka po rzutowaniu perspektywicznym:
// out vec4 gl_Position - parametr obowizkowy, nie jest deklarowany                                                                 
                                                                                    

// main - funkcja gwna skadera
void main()                                                                         
{                                                                                   
    // Obliczenie wsp. wierzchoka po rzutowaniu
	// (ustawienie wartoci gl_Position jest obowizkowe):
	gl_Position = gWVP * vec4(Position, 1.0);                                       
    
	// Wsp. tekstury - przekazujemy do nast. shadera bez zmian:
	TexCoord0   = TexCoord;                                                         
    
	// Wsp. wektora normalnego przeksztacone do uk. wsp. wiata:
	Normal0     = (gWorld * vec4(Normal, 0.0)).xyz;                                 
    
	// Wsp. wierzchoka przeksztacone do uk. wsp. wiata:
	WorldPos0   = (gWorld * vec4(Position, 1.0)).xyz;                               
}