/*
	Fragment (pixel) shader - przykad z OpenGL
	* jeden obiekt pokryty tekstur
	* owietlony jednym rdem wiata punktowego
	* model cieniowania Phonga		

	Program wykonywany jeden raz dla kadego piksela generowanego obrazu
	
	Opracowano na podstawie: http://ogldev.atspace.co.uk/www/tutorial20/tutorial20.html

*/

#version 330                                                                        
                                                                                    
// Wartoci wejciowe przekazane przez vertex shader
// Dla danego piksela s one interpolowane na podstawie wartoci
// obliczonych dla wierzchokw przez vertex shader.
// Fragment shader otrzymuje dane ju po interpolacji!                                                                                     

// Wsp. tekstury:
in vec2 texCoord0;                                                                  
// Wsp. wektora normalnego w uk. wiata:
in vec3 normal0;                                                                    
// Wsp. wierzchoka w uk. wiata:
in vec3 worldPos0;                                                                  

// Wartoci wejciowe stae (uniform)
// barwa wiata otoczenia (ambient):
uniform vec3 ambientLight;
// barwa wiata rozproszonego (diffuse):
uniform vec3 diffuseLight;
// barwa odblasku (specular):
uniform vec3 specularLight;
// intensywno odblasku:
uniform float specularPower;
// sampler - obiekt dokonujcy prbkowania tekstury
// wykonuje filtracj tekstury (dwuliniow, trjliniow, itp.)
uniform sampler2D sampler;                                                                 
// pooenie obserwatora w uk. wsp. wiata:
uniform vec3 eyeWorldPos;
// pooenie rda wiata punktowego w uk. wsp. wiata:
uniform vec3 lightPosition;                                                                  

                                                                                    
// Warto zwracana przez fragment shader jest wartoci barwy piksela:
out vec4 fragColor;                                                                 


// Gwna funkcja programu

void main()                                                                                 
{                                                                                           
    // Normalizacja wektora normalnego
    // (w wyniku interpolacji dugo wektora si zmienia)
	vec3 normal = normalize(normal0);                                                       

	// Model owietlenia ADS - Ambient + Diffuse + Specular
	
	// A - wiato otoczenia (ambient), stae
	vec4 totalLight = vec4(ambientLight, 1.0f);
                                                                                            
	// D - wiato rozproszone (diffuse), 
	// zaley od kierunku padania wiata i odlegoci od rda
    
	// Kierunek padania wiata:
	vec3 lightDirection = worldPos0 - lightPosition; 
	// (Gdyby to byo wiato kierunkowe, a nie punktowe,
	//  warto lightDirection byaby przekazywana do shadera
	//  jako parametr wejciowy uniform.)                        
    // Odlego od rda wiata:
	float distance = length(lightDirection);                                                
    lightDirection = normalize(lightDirection);                                             
                                                                                            
    // Natenie owietlenia powierzchni zaley od cosinusa kta
	// midzy wektorem padajcego wiata a wektorem normalnym.
	// Dla wektorw jednostkowych: iloczyn skalarny (dot) = cos kta midzy nimi 
	float diffuseFactor = dot(normal, -lightDirection);                                     
    if (diffuseFactor > 0) {                                                                
        // kt jest mniejszy ni 90 stopni
		vec4 diffuseColor = vec4(diffuseLight, 1.0f) * diffuseFactor;
		// Tumienie wiata ze wzrostem odlegoci,
		// tu model uproszczony: zaleno odwrotnie kwadratowa
		// (w praktyce stosuje si dokadniejsze modele)
		diffuseColor = diffuseColor / (distance * distance);
		totalLight = totalLight + diffuseColor;   
                                                                                            
        // S - odblask (specular)
		// wektor w kierunku obserwatora:
		vec3 vertexToEye = normalize(eyeWorldPos - worldPos0); 
		// wektor wiata odbitego od powierzchni:                           
        vec3 lightReflect = normalize(reflect(lightDirection, normal));
		// intensywno odblasku zaley od kta midzy tymi wektorami:                              
        float specularFactor = dot(vertexToEye, lightReflect);
        if (specularFactor > 0) {                                                           
            vec4 specularColor = vec4(specularLight, 1.0f) *                                       
            				pow(specularFactor, specularPower);                         
        	// uwaga jak wyej
			specularColor = specularColor / (distance * distance);
			totalLight = totalLight + specularColor;
		}                                                                                   
    }                                                                                       
                                                                                            
    // Kocowy wynik: kolor pobrany z tekstury * intensywno wiata                                                            
    fragColor = texture2D(sampler, texCoord0.xy) * totalLight;                             
}

