"""Filtry połówkowe (interpolacyjne, decymacyjne)"""

import numpy as np
import scipy.signal as sig
import matplotlib
import matplotlib.pyplot as plt

matplotlib.rcParams['figure.figsize'] = (8, 4)

fs = 48000

# filtr dolnoprzepustowy, połowkowy
N = 801  # długość filtru
h = sig.firwin(N, fs / 4, pass_zero='lowpass', fs=fs)
w, hf = sig.freqz(h, worN=2048, fs=fs)

plt.figure(tight_layout=True)
plt.axvline(fs / 4, ls='--', c='k', lw=1)
plt.plot(w, 20 * np.log10(np.abs(hf)))
plt.ylim(bottom=-100)
plt.xlabel('Częstotliwość [Hz]')
plt.ylabel('Poziom widma [dB]')
plt.title(f'Charakterystyka filtru DP fc=fs/4 (N={N})')
plt.grid()

h2 = sig.firwin(31, fs / 4, pass_zero='lowpass', fs=fs)
plt.figure(tight_layout=True)
plt.stem(h2, markerfmt='.', use_line_collection=True)
plt.grid()
plt.xlabel('Nr próbki')
plt.title('Odpowiedź impulsowa filtru DP fc=fs/4, N=31')

h3 = sig.firwin(31, fs / 8, pass_zero='lowpass', fs=fs)
plt.figure(tight_layout=True)
plt.stem(h3, markerfmt='.', use_line_collection=True)
plt.grid()
plt.xlabel('Nr próbki')
plt.title('Odpowiedź impulsowa filtru DP fc=fs/8, N=31')

plt.show()
