"""Charakterystyki filtrów grzebieniowych i wszechprzepustowych"""

import numpy as np
import scipy.signal as sig
import matplotlib
import matplotlib.pyplot as plt

matplotlib.rcParams['figure.figsize'] = (8, 4)

fs = 48000


def comb_fir(L, bL, b0=1):
    b = np.zeros(L)
    b[0] = b0
    b[-1] = bL
    f, hf = sig.freqz(b, 1, fs=fs)
    return b, f, hf


def comb_iir(L, aL, b0=1):
    a = np.zeros(L)
    a[0] = 1
    a[-1] = -aL
    b = [b0]
    f, hf = sig.freqz(b, a, fs=fs)
    return b, a, f, hf


def allpass(L, g):
    b = np.zeros(L)
    b[0] = g
    b[-1] = 1
    a = np.zeros(L)
    a[0] = 1
    a[-1] = g
    f, hf = sig.freqz(b, a, fs=fs)
    return b, a, f, hf


fig1, ax1 = plt.subplots(2, sharex=True, tight_layout=True, figsize=(8, 5))
L = 5
b, f, hf = comb_fir(L, 0.9)
ax1[0].plot(f, np.abs(hf), label='bL = 0.9')
b, f, hf = comb_fir(L, 0.6)
ax1[0].plot(f, np.abs(hf), ls='--', label='bL = 0.6')
b, f, hf = comb_fir(L, 0.3)
ax1[0].plot(f, np.abs(hf), ls=':', label='bL = 0.3')
ax1[0].grid()
ax1[0].legend(fontsize=8)
ax1[0].set_ylabel('Amplituda (lin)')
ax1[0].set_title(f'Filtr grzebieniowy FIR L={L}')

L = 20
b, f, hf = comb_fir(L, 0.9)
ax1[1].plot(f, np.abs(hf), label='bL = 0.9')
b, f, hf = comb_fir(L, 0.6)
ax1[1].plot(f, np.abs(hf), ls='--', label='bL = 0.6')
b, f, hf = comb_fir(L, 0.3)
ax1[1].plot(f, np.abs(hf), ls=':', label='bL = 0.3')
ax1[1].grid()
ax1[1].legend(fontsize=8)
ax1[1].set_ylabel('Amplituda (lin)')
ax1[1].set_title(f'Filtr grzebieniowy FIR L={L}')
ax1[1].set_xlabel('Częstotliwość [Hz]')


fig2, ax2 = plt.subplots(2, sharex=True, tight_layout=True, figsize=(8, 5))
L = 5
b, a, f, hf = comb_iir(L, 0.9)
ax2[0].plot(f, np.abs(hf), label='bL = 0.9')
b, a, f, hf = comb_iir(L, 0.6)
ax2[0].plot(f, np.abs(hf), ls='--', label='bL = 0.6')
b, a, f, hf = comb_iir(L, 0.3)
ax2[0].plot(f, np.abs(hf), ls=':', label='bL = 0.3')
ax2[0].grid()
ax2[0].legend(fontsize=8)
ax2[0].set_ylabel('Amplituda (lin)')
ax2[0].set_title(f'Filtr grzebieniowy IIR L={L}')

L = 20
b, a, f, hf = comb_iir(L, 0.9)
ax2[1].plot(f, np.abs(hf), label='bL = 0.9')
b, a, f, hf = comb_iir(L, 0.6)
ax2[1].plot(f, np.abs(hf), ls='--', label='bL = 0.6')
b, a, f, hf = comb_iir(L, 0.3)
ax2[1].plot(f, np.abs(hf), ls=':', label='bL = 0.3')
ax2[1].grid()
ax2[1].legend(fontsize=8)
ax2[1].set_title(f'Filtr grzebieniowy IIR L={L}')
ax2[1].set_ylabel('Amplituda (lin)')
ax2[1].set_xlabel('Częstotliwość [Hz]')


fig3, ax3 = plt.subplots(2, sharex=True, tight_layout=True, figsize=(8, 5))
fig4, ax4 = plt.subplots(2, sharex=True, tight_layout=True, figsize=(8, 5))
L = 5
b, a, f, hf = allpass(L, 0.9)
ax3[0].plot(f, np.abs(hf), label='bL = 0.9')
ax4[0].plot(*sig.group_delay((b, a), fs=fs), label='bL = 0.9')
b, a, f, hf = allpass(L, 0.6)
ax3[0].plot(f, np.abs(hf), ls='--', label='bL = 0.6')
ax4[0].plot(*sig.group_delay((b, a), fs=fs), label='bL = 0.6')
b, a, f, hf = allpass(L, 0.3)
ax3[0].plot(f, np.abs(hf), ls=':', label='bL = 0.3')
ax4[0].plot(*sig.group_delay((b, a), fs=fs), label='bL = 0.3')
ax3[0].grid()
ax3[0].legend(fontsize=8)
ax3[0].set_ylabel('Amplituda (lin)')
ax3[0].set_title(f'Filtr wszechprzepustowy L={L}')
ax3[0].set_ylim(0, 2)

ax4[0].grid()
ax4[0].legend(fontsize=8)
ax4[0].set_ylabel('Opóźnienie [próbki]')
ax4[0].set_title(f'Filtr wszechprzepustowy L={L}')

L = 20
b, a, f, hf = allpass(L, 0.9)
ax3[1].plot(f, np.abs(hf), label='bL = 0.9')
ax4[1].plot(*sig.group_delay((b, a), fs=fs), label='bL = 0.9')
b, a, f, hf = allpass(L, 0.6)
ax3[1].plot(f, np.abs(hf), ls='--', label='bL = 0.6')
ax4[1].plot(*sig.group_delay((b, a), fs=fs), label='bL = 0.6')
b, a, f, hf = allpass(L, 0.3)
ax3[1].plot(f, np.abs(hf), ls=':', label='bL = 0.3')
ax4[1].plot(*sig.group_delay((b, a), fs=fs), label='bL = 0.3')
ax3[1].grid()
ax3[1].legend(fontsize=8)
ax3[1].set_title(f'Filtr wszechprzepustowy L={L}')
ax3[1].set_ylabel('Amplituda (lin)')
ax3[1].set_xlabel('Częstotliwość [Hz]')
ax3[1].set_ylim(0, 2)

ax4[1].grid()
ax4[1].legend(fontsize=8)
ax4[1].set_title(f'Filtr wszechprzepustowy L={L}')
ax4[1].set_ylabel('Opóźnienie [próbki]')
ax4[1].set_xlabel('Częstotliwość [Hz]')

delta = np.zeros(200)
delta[0] = 1

b, a, f, hf = allpass(20, 0.9)
ir = sig.lfilter(b, a, delta)
fig5, ax5 = plt.subplots(tight_layout=True)
ax5.stem(ir, markerfmt='.', use_line_collection=True)
ax5.grid()
ax5.set_xlabel('Nr próbki')
ax5.set_ylabel('Amplituda')
ax5.set_title('Odpowiedź impulsowa filtru wszechprzepustowego L=20')

b, a, f, hf = comb_iir(20, 0.9)
ir = sig.lfilter(b, a, delta)
fig6, ax6 = plt.subplots(tight_layout=True)
ax6.stem(ir, markerfmt='.', use_line_collection=True)
ax6.grid()
ax6.set_xlabel('Nr próbki')
ax6.set_ylabel('Amplituda')
ax6.set_title('Odpowiedź impulsowa filtru grzebieniowego IIR L=20')

b, f, hf = comb_fir(20, 0.9)
ir = sig.lfilter(b, [1], delta)
fig7, ax7 = plt.subplots(tight_layout=True)
ax7.stem(ir, markerfmt='.', use_line_collection=True)
ax7.grid()
ax7.set_xlabel('Nr próbki')
ax7.set_ylabel('Amplituda')
ax7.set_title('Odpowiedź impulsowa filtru grzebieniowego FIR L=20')

plt.show()
