"""Filtr składowej stałej"""

import numpy as np
import scipy.signal as sig
from matplotlib import pyplot as plt

fs = 48000

fig1, ax1 = plt.subplots(tight_layout=True, figsize=(8, 4))
for alpha in (0.998, 0.9, 0.7, 0.5):
    w, hf = sig.freqz([1, -1], [1, -alpha], fs=fs)
    ax1.plot(w, 20 * np.log10(np.maximum(np.abs(hf), 1e-12)), label=f'α={alpha}')
ax1.set_xlabel('Częstotliwość [Hz]')
ax1.set_ylabel('Wzmocnienie [dB]')
ax1.grid()
ax1.legend()

fig2, ax2 = plt.subplots(tight_layout=True, figsize=(8, 4))
for alpha in (0.998, 0.9, 0.7, 0.5):
    with np.warnings.catch_warnings():
        np.warnings.filterwarnings('ignore')
        w, gd = sig.group_delay(([1, -1], [1, -alpha]), fs=fs)
    gd[0] = None
    ax2.plot(w, gd, label=f'α={alpha}')
ax2.set_xlabel('Częstotliwość [Hz]')
ax2.set_ylabel('Opóźnienie [próbki]')
ax2.set_ylim(top=10)
ax2.grid()
ax2.legend()

# sygnał testowy
speech = np.load('speech.npy')
speech = speech / 32768.0
sp_dc = speech + 0.1
sp_proc = sig.lfilter([1, -1], [1, -0.998], sp_dc)

fig, ax = plt.subplots(2, sharex=True, tight_layout=True, figsize=(8, 5))
ax[0].plot(sp_dc, label='sygnał z DC')
ax[0].axhline(np.mean(sp_dc), lw=1, c='r', label='średnia')
ax[0].set_ylabel('Amplituda')
ax[1].plot(sp_proc, label='przetworzony')
ax[1].axhline(np.mean(sp_proc), lw=1, c='r', label='średnia')
ax[1].set_ylabel('Amplituda')
for a in ax:
    a.grid()
    a.legend()
ax[-1].set_xlabel('Nr próbki')

plt.show()
