"""Filtr całkujący"""

import numpy as np
import scipy.signal as sig
from matplotlib import pyplot as plt

fs = 48000

plt.figure(tight_layout=True, figsize=(8, 4))
for alpha in (0.998, 0.95, 0.9):
    w, hf = sig.freqz([1], [1, -alpha], fs=fs)
    plt.plot(w, 20 * np.log10(np.abs(hf)), label=f'α={alpha}')
plt.xlabel('Częstotliwość [Hz]')
plt.ylabel('Wzmocnienie [dB]')
plt.grid()
plt.legend()

# sygnał testowy
# https://www.mathworks.com/help/signal/examples/practical-introduction-to-digital-filtering.html
alpha = 0.998
pos = np.load('pos.npy')
vel = sig.lfilter([1, -1], 1, pos)[1:]
pint = sig.lfilter([1], [1, -alpha], vel)
zpk = sig.tf2zpk([1], [1, -alpha])
print(np.abs(zpk[1]))

fig, ax = plt.subplots(2, sharex=True, tight_layout=True, figsize=(8, 5))
ax[0].plot(vel)
ax[0].set_ylabel('Prędkość [cm/s]')
ax[1].plot(pos, c='#c0c0c0', label='oryginalna')
ax[1].plot(pint, label='obliczona')
ax[1].set_ylabel('Położenie [cm]')
for a in ax:
    a.grid()
ax[-1].set_xlabel('Nr próbki')

plt.show()
