"""Filtr różniczkujący"""

import numpy as np
import scipy.signal as sig
from matplotlib import pyplot as plt

fs = 48000

# idealny filtr różniczkujący: H(z) = jω
N = 51
h = sig.firwin2(N, [0, 1 - 1e-5, 1], [0, np.pi, 0],
        window='hamming', antisymmetric=True)

w, hf = sig.freqz(h, fs=fs)
ideal = 1j * 2 * np.pi * w / fs
wn, hfn = sig.freqz([1, -1], fs=fs)

plt.figure(tight_layout=True, figsize=(8, 4))
plt.plot(w, np.abs(ideal), ls='--', c='#a0a0a0', label='idealna')
plt.plot(w, np.abs(hf), label='zaprojektowana')
plt.plot(wn, np.abs(hfn), label='"naiwna"')
plt.xlabel('Częstotliwość [Hz]')
plt.ylabel('Wzmocnienie (lin)')
plt.grid()
plt.legend()

# sygnał testowy
# https://www.mathworks.com/help/signal/examples/practical-introduction-to-digital-filtering.html
pos = np.load('pos.npy')
vel = sig.lfilter(h, 1, pos)[(N - 1):] * 1000
tp = np.arange(len(pos)) / 1000
tv = np.arange(len(vel)) / 1000

fig, ax = plt.subplots(2, sharex=True, tight_layout=True, figsize=(8, 5))
ax[0].plot(tp, pos)
ax[0].set_ylabel('Położenie [cm]')
ax[1].plot(tv, vel)
ax[1].set_ylabel('Prędkość [cm/s]')
for a in ax:
    a.grid()
ax[-1].set_xlabel('Czas [s]')

plt.show()
