"""Filtracja adaptacyjna metodami LMS i NLMS."""

import numpy as np


class LMS:
    def __init__(self, length, step, normalized=False, random=False):
        self.length = length
        self.normalized = normalized
        self.mu = step
        if random:
            self.w = np.random.randn(self.length)
        else:
            self.w = np.zeros(self.length, dtype=np.float)
        self.xbuf = np.zeros(self.length, dtype=np.float)

    def __call__(self, x, d):
        self.xbuf = np.roll(self.xbuf, 1)
        self.xbuf[0] = x
        y = np.dot(self.w, self.xbuf)
        e = d - y
        if self.normalized:
            mu = self.mu / np.maximum(np.dot(self.xbuf, self.xbuf), 0.001)
            self.w += mu * e * self.xbuf
        else:
            self.w += self.mu * e * self.xbuf
        return y, e

    def run(self, x, d):
        res = np.asarray(np.vstack([self.__call__(v, d) for v, d in zip(x, d)]))
        y, e = res.T
        return y, e
