"""Odszumianie sygnału metodą adaptacyjnej filtracji predykcyjnej."""

# przykład z książki T. Zielińskiego
# "Cyfrowe przetwarzanie sygnałów - od teorii do zastosowań"
# rozdział 14.8

import numpy as np
from matplotlib import pyplot as plt
from lms import LMS


t = np.arange(1000) / 1000
N = 1000
fs = 1000

# sygnał oryginalny
s = np.cos(20 * np.pi * (np.arange(N) / fs)**2)
# zakłócenie
n = 0.25 * np.random.randn(N)
# sygnał referencyjny d: sygnał + zakłócenie
# sygnał x na wejściu filtru: sygnał referencyjny opóźniony o 1 próbkę
x = s + n
d = np.roll(x, -1)
d[-1] = 0

# filtr NLMS
lms = LMS(50, 0.01, normalized=True)
y, e = lms.run(x, d)

fig, ax = plt.subplots(2, sharex=True, tight_layout=True, figsize=(8, 5))
ax[0].plot(d)
ax[0].set_title('Sygnał zaszumiony')
ax[1].plot(s, c='#a0a0a0')
ax[1].plot(y)
ax[1].set_title('Sygnał przetworzony')
for a in ax:
    a.grid()
    a.set_ylabel('Amplituda')
ax[-1].set_xlabel('Nr próbki')
plt.show()
