"""Filtracja adaptacyjna metodami LMS i NLMS."""

import numpy as np
import scipy.signal as sig
from matplotlib import pyplot as plt
from lms import LMS


# Identyfikacja systemu
x = np.random.randn(3000)

# system - filtr DP 3 kHz
L = 31
h = sig.firwin(L, 3, window='hamming', pass_zero='lowpass', fs=48)
y_sys = sig.lfilter(h, 1, x)

mu = 0.001
lms = LMS(L, mu, random=True)
y, e = lms.run(x, y_sys)

mu2 = 0.01
lms2 = LMS(L, mu2, random=True)
y2, e2 = lms2.run(x, y_sys)

alpha = 1
lms3 = LMS(L, alpha, normalized=True, random=True)
y3, e3 = lms3.run(x, y_sys)

fig, ax = plt.subplots(3, sharex=True, figsize=(8, 5), tight_layout=True)
ax[0].plot(e**2, label=f'LMS μ={mu}')
ax[1].plot(e2**2, label=f'LMS μ={mu2}')
ax[2].plot(e3**2, label=f'NLMS α={alpha}')
for a in ax:
    a.grid()
    a.set_ylabel('Bład kw.')
    a.legend()
ax[-1].set_xlabel('Iteracja')

w_sys, hf_sys = sig.freqz(h, fs=48000)

fig2, ax2 = plt.subplots(3, sharex=True, figsize=(8, 6), tight_layout=True)
for a, it in zip(ax2, (500, 1000, 1500)):
    lms4 = LMS(L, 0.01)
    lms4.run(x[:it], y_sys[:it])
    w_est, hf_est = sig.freqz(lms4.w, fs=48000)
    a.plot(w_sys, 20 * np.log10(np.abs(hf_sys)), c='#c0c0c0', label='Rzeczywisty')
    a.plot(w_est, 20 * np.log10(np.abs(hf_est)), ls='--', label='Estymowany')
    a.set_title(f'Po {it} iteracjach', fontsize=10)
    a.legend(loc='lower left', fontsize=8)
    a.grid()
    a.set_ylabel('Wzm. [dB]')
ax2[-1].set_xlabel('Częstotliwość [Hz]')

plt.show()
