"""Porównanie filtrów FIR i IIR"""

import numpy as np
import scipy.signal as sig
import matplotlib
import matplotlib.pyplot as plt

matplotlib.rcParams['figure.figsize'] = (8, 4)

fs = 48000

# filtr DP
# pasmo przejściowe 3000 - 3200 Hz
# Rp = 1 dB
# Rz = 60 dB

# filtr IIR
b1, a1 = sig.iirdesign(3000, 3200, gpass=1, gstop=60, ftype='ellip', fs=fs)
w_iir1, hf_iir1 = sig.freqz(b1, a1, worN=2048, fs=fs)
n_iir1 = len(b1) - 1

# filtr FIR
n, beta = sig.kaiserord(60, 2 * 200 / 48000)
h1 = sig.firwin(n, 3000, window=('kaiser', beta), pass_zero='lowpass', fs=fs)
w_fir1, hf_fir1 = sig.freqz(h1, worN=2048, fs=fs)
n_fir1 = n - 1

n_fir2 = 2 * n_iir1 + 1
h2 = sig.firwin(n_fir2, 3000, window=('kaiser', sig.kaiser_beta(60)), pass_zero='lowpass', fs=fs)
w_fir2, hf_fir2 = sig.freqz(h2, worN=2048, fs=fs)

fig1, ax1 = plt.subplots(tight_layout=True)
ax1.plot(w_iir1, 20 * np.log10(np.abs(hf_iir1)), label=f'IIR N={n_iir1}')
ax1.plot(w_fir1, 20 * np.log10(np.abs(hf_fir1)), label=f'FIR N={n_fir1}')
ax1.grid()
ax1.legend()
ax1.set_ylim(bottom=-120)
ax1.set_xlim(0, 12000)
ax1.set_ylabel('Wzmocnienie [dB]')
ax1.set_xlabel('Częstotliwość [Hz]')

fig2, ax2 = plt.subplots(tight_layout=True)
ax2.plot(w_iir1, 20 * np.log10(np.abs(hf_iir1)), label=f'IIR N={n_iir1}')
ax2.plot(w_fir2, 20 * np.log10(np.abs(hf_fir2)), label=f'FIR N={n_fir2 - 1}')
ax2.grid()
ax2.legend()
ax2.set_ylim(bottom=-120)
ax2.set_xlim(0, 12000)
ax2.set_ylabel('Wzmocnienie [dB]')
ax2.set_xlabel('Częstotliwość [Hz]')

plt.show()
