"""Ilustracja niestabilności filtru wysokiego rzędu"""

import numpy as np
import scipy.signal as sig
import matplotlib
import matplotlib.pyplot as plt

matplotlib.rcParams['figure.figsize'] = (8, 4)


def plot_impresp(h):
    fig, ax = plt.subplots()
    stem = ax.stem(h, use_line_collection=True)
    stem[0].set_markersize(3)
    ax.set_xlabel('Nr próbki')
    ax.set_ylabel('Amplituda')
    return ax


fs = 48000

x = np.zeros(200, dtype=np.float64)
x[0] = 1

# filtr DP 3 kHz eliptyczny, rzędu 20
b, a = sig.iirfilter(20, 3000, btype='lowpass', ftype='ellip', rp=1, rs=60, fs=fs)
y1 = sig.lfilter(b, a, x)
ax1 = plot_impresp(y1)

z, p, k = sig.tf2zpk(b, a)
print(np.max(np.abs(p)))

# filtr SOS
sos = sig.iirfilter(20, 3000, btype='lowpass', ftype='ellip', rp=1, rs=60, fs=fs, output='sos')
y2 = sig.sosfilt(sos, x)
ax2 = plot_impresp(y2)

plt.show()
