"""Efekty opóźnienia w filtrach IIR"""

import numpy as np
import scipy.signal as sig
import matplotlib
import matplotlib.pyplot as plt

matplotlib.rcParams['figure.figsize'] = (8, 4)

fs = 48000

# sygnały wejściowe: sin(500 Hz) + 0.5 * sin(2500 Hz)
t = np.arange(500)
x1 = np.sin(2 * np.pi * t * 500 / fs)
x2 = np.sin(2 * np.pi * t * 2500 / fs) * 0.5
x = x1 + x2

# filtr DP 3 kHz eliptyczny
b, a = sig.iirfilter(8, 3000, btype='lowpass', ftype='ellip', rp=1, rs=60, fs=fs)

# sygnały po filtracji
y1 = sig.lfilter(b, a, x1)
y2 = sig.lfilter(b, a, x2)
y = sig.lfilter(b, a, x)

fig, ax = plt.subplots(2, figsize=(8, 6), tight_layout=True)
ax[0].plot(x1)
ax[0].plot(x2)
ax[1].plot(y1)
ax[1].plot(y2)
for aa in ax:
    aa.grid()
    aa.set_ylabel('Amplituda')
ax[1].set_xlabel('Nr próbki')
ax[0].set_title('Sygnał oryginalny')
ax[1].set_title('Sygnał po filtracji')

fig, ax = plt.subplots(2, figsize=(8, 6), tight_layout=True)
ax[0].plot(x)
ax[1].plot(y)
for aa in ax:
    aa.grid()
    aa.set_ylabel('Amplituda')
ax[1].set_xlabel('Nr próbki')
ax[0].set_title('Sygnał oryginalny')
ax[1].set_title('Sygnał po filtracji')

# filtracja zerofazowa
y2 = sig.filtfilt(b, a, x)

fig, ax = plt.subplots(2, figsize=(8, 6), tight_layout=True)
ax[0].plot(x)
ax[1].plot(y2)
for aa in ax:
    aa.grid()
    aa.set_ylabel('Amplituda')
ax[1].set_xlabel('Nr próbki')
ax[0].set_title('Sygnał oryginalny')
ax[1].set_title('Sygnał po filtracji zerofazowej')

plt.show()
