"""Efekt transformacji prototypu DP w filtr PP - zwiększenie rzędu"""

import numpy as np
import scipy.signal as sig
import matplotlib
import matplotlib.pyplot as plt

matplotlib.rcParams['figure.figsize'] = (8, 4)

fs = 48000
N = 8
fd = 4000
fg = 8000

# filtr DP
bd, ad = sig.iirfilter(N, fg, btype='lowpass', ftype='ellip', rp=1, rs=60, fs=fs)
wd, hd = sig.freqz(bd, ad, 2048, fs=fs)
hdd = 20 * np.log10(np.abs(hd))
print(len(bd))

# filtr GP
bg, ag = sig.iirfilter(N, fd, btype='highpass', ftype='ellip', rp=1, rs=60, fs=fs)
wg, hg = sig.freqz(bg, ag, 2048, fs=fs)
hgd = 20 * np.log10(np.abs(hg))

# filtry PP
bp, ap = sig.iirfilter(N, (fd, fg), btype='bandpass', ftype='ellip', rp=1, rs=60, fs=fs)
wp, hp = sig.freqz(bp, ap, 2048, fs=fs)
hpd = 20 * np.log10(np.abs(hp))
print(len(bp))

bp2, ap2 = sig.iirfilter(N // 2, (fd, fg), btype='bandpass', ftype='ellip', rp=1, rs=60, fs=fs)
wp2, hp2 = sig.freqz(bp2, ap2, 2048, fs=fs)
hp2d = 20 * np.log10(np.abs(hp2))

fig, ax = plt.subplots(2, tight_layout=True, figsize=(8, 6))
ax[0].plot(wd, hdd, label=f'DP N={N}')
ax[0].plot(wg, hgd, label=f'GP N={N}')
ax[1].plot(wp, hpd, label=f'PP N={N * 2}')
ax[1].plot(wp2, hp2d, label=f'PP N={N}')
for aa in ax:
    aa.grid()
    aa.set_xlim(0, 12000)
    aa.set_ylim(bottom=-80)
    aa.set_ylabel('Wzmocnienie [dB]')
    aa.legend()
ax[1].set_xlabel('Częstotliwość [Hz]')

plt.show()
