"""Parametry projektu filtru IIR."""

import numpy as np
import scipy.signal as sig
from matplotlib import pyplot as plt


# filtr DP Butterwortha
fd = 3000
fg = 4000
rp = 0.1
rz = 0.9

gpass = 20 * np.log10(1 + rp)
gstop = 20 * np.log10(1 / (1 - rz))

print(gpass, gstop)

b, a = sig.iirdesign(fd, fg, gpass, gstop, fs=48000)
print(len(b))

w, h = sig.freqz(b, a, 2048, fs=48000)

fig, ax = plt.subplots(tight_layout=True)

x_low = [0, 3000, 3000 + 1e-6, 24000]
y_low = [1 - rp, 1 - rp, -0.1, -0.1]
x_high = [0, 4000, 4000 + 1e-6, 24000]
y_high = [1 + rp, 1 + rp, 1 - rz, 1 - rz]

# ax.plot(x_low, y_low, c='tab:red')
ax.fill_between(x_low, y_low, -0.1, color='tab:red', alpha=0.25)
# ax.plot(x_high, y_high, c='tab:red')
ax.fill_between(x_high, y_high, 1.25, color='tab:red', alpha=0.25)

ax.plot(w, np.abs(h))

ax.grid()
ax.set_xlim(0, 8000)
ax.set_ylim(0, 1.2)
ax.set_xlabel('Częstotliwość [Hz]')
ax.set_ylabel('Wzmocnienie [lin]')

ax.set_yticks([0, 0.1, 0.2, 0.4, 0.6, 0.8, 0.9, 1.0, 1.1])
ax.set_yticklabels(['0', '1-Rz', '', '', '', '', '1-Rp', '1', '1+Rp'])

plt.show()
