"""Stabilność filtru"""

import numpy as np
import scipy.signal as sig
import matplotlib
import matplotlib.pyplot as plt

matplotlib.rcParams['figure.figsize'] = (8, 4)


def plot_impresp(h):
    fig, ax = plt.subplots()
    stem = ax.stem(h, use_line_collection=True)
    stem[0].set_markersize(3)
    ax.set_xlabel('Nr próbki')
    ax.set_ylabel('Amplituda')
    return ax


fs = 48000

x = np.zeros(100, dtype=np.float64)
x[0] = 1

# filtr stabilny: a = 0.9
y1 = sig.lfilter([1], [1, -0.9], x)
ax1 = plot_impresp(y1)
print(', '.join(format(x, '.4f') for x in y1[:10]))

# filtr na granicy: a = 1
y2 = sig.lfilter([1], [1, -1], x)
ax2 = plot_impresp(y2)

# filtr niestabiolny: a = 1.1
y3 = sig.lfilter([1], [1, -1.1], x)
ax3 = plot_impresp(y3)
print(', '.join(format(x, '.4f') for x in y3[:10]))

# filtr stabilny, DP 3 kHz
b, a = sig.iirdesign(3000, 4000, 1, 40, fs=48000)
y4 = sig.lfilter(b, a, x)
ax4 = plot_impresp(y4)

# filtr na granicy stabilności - generator sinusa
f0 = 1000
alpha = 2 * np.cos(2 * np.pi * f0 / fs)
x_gen = np.zeros(100, dtype=np.float64)
b_gen = [1]
a_gen = [1, -alpha, 1]
init = sig.lfiltic(b_gen, a_gen, [np.sin(2 * np.pi * f0 / fs), 0])
y_gen = sig.lfilter(b_gen, a_gen, x_gen, zi=init)[0]
ax5 = plot_impresp(y_gen)


plt.show()
