"""Filtry analogowe"""

import numpy as np
import scipy.signal as sig
import matplotlib
import matplotlib.pyplot as plt

matplotlib.rcParams['figure.figsize'] = (8, 4)

fs = 48000

# filtr DP pierwszego rzędu, 3 kHz
om_c = 2 * np.pi * 3000
worN = np.linspace(0, 12000, 512) * 2 * np.pi
w1, h1 = sig.freqs([om_c], [1, om_c], worN)
plt.figure()
plt.plot(w1 / (2 * np.pi), 20 * np.log10(np.abs(h1)))
plt.axvline(3000, lw=1, ls='--', c='#808080')
plt.axhline(-3, lw=1, ls='--', c='#808080')
plt.grid()
plt.xlabel('Częstotliwość [Hz]')
plt.ylabel('Poziom widma [dB]')
plt.title('Charakterystyka filtru dolnoprzepustowego 3 kHz 1. rzędu')


# filtr DP drugiego rzędu, 3 kHz
om2_c = om_c**2
b = [om2_c]
a = [1, np.sqrt(2) * om_c, om2_c]
w2, h2 = sig.freqs(b, a, worN)
plt.figure()
plt.plot(w1 / (2 * np.pi), 20 * np.log10(np.abs(h1)), c='#c0c0c0', label='Rząd 1')
plt.plot(w2 / (2 * np.pi), 20 * np.log10(np.abs(h2)), label='Rząd 2')
plt.axvline(3000, lw=1, ls='--', c='#808080')
plt.axhline(-3, lw=1, ls='--', c='#808080')
# plt.axhline(-6, lw=1, ls='--', c='#808080')
plt.grid()
plt.legend()
plt.xlabel('Częstotliwość [Hz]')
plt.ylabel('Poziom widma [dB]')
plt.title('Charakterystyka filtru dolnoprzepustowego 3 kHz 2. rzędu')

# bilinear transform
b2, a2 = sig.bilinear(b, a, fs)
print(b2, a2)

# filtr DP cyfrowy drugiego rzędu
w2d, h2d = sig.freqz(b2, a2, fs=fs)
plt.figure()
plt.plot(w2 / (2 * np.pi), 20 * np.log10(np.abs(h2)), c='#c0c0c0', label='Analogowy')
plt.plot(w2d, 20 * np.log10(np.abs(h2d)), label='Cyfrowy')
plt.axvline(3000, lw=1, ls='--', c='#808080')
plt.axhline(-3, lw=1, ls='--', c='#808080')
plt.xlim(0, 12000)
plt.ylim(-30, 2)
plt.grid()
plt.legend()
plt.xlabel('Częstotliwość [Hz]')
plt.ylabel('Poziom widma [dB]')
plt.title('Charakterystyka filtru dolnoprzepustowego 3 kHz 2. rzędu')


plt.show()
