"""Obliczanie szybkiego splotu - benchmark"""

import numpy as np
import scipy.signal as sig
import matplotlib
import matplotlib.pyplot as plt
from tqdm import tqdm

matplotlib.rcParams['figure.figsize'] = (8, 4)

length = np.arange(10, 5000, 10)
t_fft = []
t_direct = []
for n in tqdm(length, ascii=False):
    x = np.ones(n)
    method, times = sig.choose_conv_method(x, x, 'full', True)
    t_fft.append(times['fft'] * 1000)
    t_direct.append(times['direct'] * 1000)

plt.figure()
plt.plot(length, t_direct, label='W d. czasu')
plt.plot(length, t_fft, label='W d. częstotliwości')
plt.grid()
plt.legend()
plt.xlabel('Długość sygnału [próbki]')
plt.ylabel('Czas obliczeń [ms]')
plt.title('Czas wykonania splotu x*x')

plt.show()
