"""Metody optymalizacyjne projektowania filtrów"""

import numpy as np
import scipy.signal as sig
import matplotlib
import matplotlib.pyplot as plt

matplotlib.rcParams['figure.figsize'] = (8, 4)

fs = 48000
N = 301  # długość filtru

bands = (0, 3000, 4200, fs / 2)
desired = (1, 1, 0, 0)

h_win = sig.firwin2(N, bands, desired, fs=fs)
w_win, hf_win = sig.freqz(h_win, worN=2048, fs=fs)

h_ls = sig.firls(N, bands, desired, fs=fs)
w_ls, hf_ls = sig.freqz(h_ls, worN=2048, fs=fs)

h_pm = sig.remez(N, bands, desired[::2], fs=fs)
w_pm, hf_pm = sig.freqz(h_pm, worN=2048, fs=fs)

w_id = np.linspace(0.0, fs / 2, 2048)
ideal = np.interp(w_id, bands, desired)
ideal_db = 20 * np.log10(np.maximum(ideal, 1e-8))

fig1, ax1 = plt.subplots(2, sharex=True, tight_layout=True, figsize=(8, 5))
ax1[0].plot(w_id, ideal, c='k', ls='--', label='Idealna')
ax1[0].plot(w_win, np.abs(hf_win), label='Okienkowanie')
ax1[0].plot(w_ls, np.abs(hf_ls), label='LS')
ax1[0].set_ylabel('Wzmocnienie (lin)')
ax1[1].plot(w_id, ideal_db, c='k', ls='--', label='Idealna')
ax1[1].plot(w_win, 20 * np.log10(np.abs(hf_win)), label='Okienkowanie')
ax1[1].plot(w_ls, 20 * np.log10(np.abs(hf_ls)), label='LS')
ax1[1].set_ylim(bottom=-140)
ax1[1].set_xlim(0, 12000)
# ax1[1].set_xlim(2500, 5000)
for a in ax1:
    a.legend()
    a.grid()
ax1[1].set_ylabel('Wzmocnienie [dB]')
ax1[1].set_xlabel('Częstotliwość [Hz]')
ax1[0].set_title(f'Charakterystyki widmowe filtru')


fig2, ax2 = plt.subplots(2, sharex=True, tight_layout=True, figsize=(8, 5))
ax2[0].plot(w_id, ideal, c='k', ls='--', label='Idealna')
ax2[0].plot(w_win, np.abs(hf_win), label='Okienkowanie')
ax2[0].plot(w_pm, np.abs(hf_pm), label='Parks-McClellan')
ax2[0].set_ylabel('Wzmocnienie (lin)')
ax2[1].plot(w_id, ideal_db, c='k', ls='--', label='Idealna')
ax2[1].plot(w_win, 20 * np.log10(np.abs(hf_win)), label='Okienkowanie')
ax2[1].plot(w_pm, 20 * np.log10(np.abs(hf_pm)), label='Parks-McClellan')
ax2[1].set_ylim(bottom=-140)
ax2[1].set_xlim(0, 12000)
for a in ax2:
    a.legend()
    a.grid()
ax2[1].set_ylabel('Wzmocnienie [dB]')
ax2[1].set_xlabel('Częstotliwość [Hz]')
ax2[0].set_title('Charakterystyki widmowe filtru')

plt.show()
