"""Odpowiedzi impulsowe filtrów o róznej charakterystyce"""

import numpy as np
import scipy.signal as sig
import matplotlib
import matplotlib.pyplot as plt

matplotlib.rcParams['figure.figsize'] = (8, 4)

fs = 48000
N = 101  # długość filtru
M = (N - 1) // 2

hdp = sig.firwin(N, 3000, window='hamming', pass_zero='lowpass', fs=fs)
hgp = sig.firwin(N, 3000, window='hamming', pass_zero='highpass', fs=fs)

fig1, ax1 = plt.subplots(2, sharex=True, tight_layout=True, figsize=(8, 5))
stem = ax1[0].stem(hdp, use_line_collection=True)
stem[0].set_markersize(3)
stem = ax1[1].stem(hgp, use_line_collection=True)
stem[0].set_markersize(3)
ax1[1].set_xlabel('Nr próbki')
ax1[0].set_title('Odpowiedź impulsowa filtru DP 3 kHz')
ax1[1].set_title('Odpowiedź impulsowa filtru GP 3 kHz')

hpp = sig.firwin(N, (1000, 3000), window='hamming', pass_zero='bandpass', fs=fs)
hpz = sig.firwin(N, (1000, 3000), window='hamming', pass_zero='bandstop', fs=fs)

fig2, ax2 = plt.subplots(2, sharex=True, tight_layout=True, figsize=(8, 5))
stem = ax2[0].stem(hpp, use_line_collection=True)
stem[0].set_markersize(3)
stem = ax2[1].stem(hpz, use_line_collection=True)
stem[0].set_markersize(3)
ax2[1].set_xlabel('Nr próbki')
ax2[0].set_title('Odpowiedź impulsowa filtru PP 1-3 kHz')
ax2[1].set_title('Odpowiedź impulsowa filtru PZ 1/3 kHz')

N2 = 31
hdp1 = sig.firwin(N2, 3000, window='hamming', pass_zero='lowpass', fs=fs)
hdp2 = sig.firwin(N2 - 1, 3000, window='hamming', pass_zero='lowpass', fs=fs)

fig3, ax3 = plt.subplots(2, sharex=True, tight_layout=True, figsize=(8, 5))
stem = ax3[0].stem(hdp1, use_line_collection=True)
stem[0].set_markersize(3)
stem = ax3[1].stem(hdp2, use_line_collection=True)
stem[0].set_markersize(3)
ax3[1].set_xlabel('Nr próbki')
ax3[0].set_title(f'Odpowiedź impulsowa filtru DP 3 kHz N={N2}')
ax3[1].set_title(f'Odpowiedź impulsowa filtru GP 3 kHz N={N2 - 1}')


plt.show()
