"""Charakterystyki fazowe filtru FIR"""

import numpy as np
import scipy.signal as sig
import matplotlib
import matplotlib.pyplot as plt

matplotlib.rcParams['figure.figsize'] = (8, 4)

fs = 48000
N = 101  # długość filtru
M = (N - 1) // 2

h = sig.firwin(N, 3000, window='hamming', fs=fs)
w, hf = sig.freqz(h, worN=2048, fs=fs)
hfdb = 20 * np.log10(np.abs(hf))
phase = np.degrees(np.angle(hf))
wgd, gd = sig.group_delay((h, 1), 2048, fs=fs)

# odpowiedzi impulsowe - nieprzyczynowa i przyczynowa
fig1, ax1 = plt.subplots(2, sharex=True, tight_layout=True, figsize=(8, 5))
idx = np.arange(len(h))
stem = ax1[0].stem(idx - M, h, use_line_collection=True)
stem[0].set_markersize(3)
stem = ax1[1].stem(idx, h, use_line_collection=True)
stem[0].set_markersize(3)
ax1[1].set_xlabel('Nr próbki')
ax1[0].set_title('Odpowiedź impulsowa filtru nieprzyczynowego')
ax1[1].set_title('Odpowiedź impulsowa filtru przyczynowego')

# charakterystyka fazowa
plt.figure(2)
plt.axvline(3000, c='k', lw=1, ls='--')
plt.plot(w, phase)
plt.grid()
plt.ylim(-180, 180)
plt.xlabel('Częstotliwość [Hz]')
plt.ylabel('Faza [°]')
plt.title('Charakterystyka fazowa filtru DP 3 kHz')

# charakterystyka opóźnienia grupowego
plt.figure(3)
plt.plot(wgd, gd)
plt.grid()
plt.ylim(0, N)
plt.xlabel('Częstotliwość [Hz]')
plt.ylabel('Opóźnienie [próbki]')
plt.title('Charakterystyka opóźnienia grupowego filtru DP 3 kHz')

# sygnał oryginalny i opóźniony
t = np.arange(2000) / fs
fr = np.array([100, 200, 300, 400, 500]).reshape(-1, 1)
# x = np.sum(np.sin(2 * np.pi * np.outer(t, fr) / fs), axis=0)
x = np.sum(np.sin(2 * np.pi * t * fr), axis=0)
# x = np.sin(2 * np.pi * t * 100)
y = sig.lfilter(h, 1, x)

fig4, ax4 = plt.subplots(2, sharex=True, tight_layout=True, figsize=(8, 5))
ax4[0].plot(x)
# ax4[1].axvline(M, c='#808080', lw=1, ls='--')
ax4[1].plot(y)
for a in ax4:
    a.grid()
    a.set_ylabel('Amplituda')
ax4[1].set_xlim(0, 1500)
ax4[1].set_xlabel('Nr próbki')
ax4[0].set_title('Sygnał oryginalny')
ax4[1].set_title('Sygnał po filtracji')

plt.show()
