"""Różne typy okien czasowych."""

import numpy as np
import scipy.signal as sig
import matplotlib
import matplotlib.pyplot as plt

matplotlib.rcParams['figure.figsize'] = (8, 4)

N = 101
x = np.arange(N) - (N - 1) // 2

plt.figure()
plt.plot(x, np.hamming(N), label='Hamminga')
plt.plot(x, np.hanning(N), label='von Hanna')
plt.plot(x, np.blackman(N), label='Blackmana')
plt.grid()
plt.legend()
plt.xlabel('Nr próbki')
plt.ylabel('Amplituda')
plt.title('Kształty typowych funkcji okna')

# okno Kaisera
plt.figure()
for beta in (5, 8.6, 14, 20):
    plt.plot(x, np.kaiser(N, beta), label=f'β={beta}')
plt.grid()
plt.legend()
plt.xlabel('Nr próbki')
plt.ylabel('Amplituda')
plt.title('Kształty okna Kaisera dla różnego β')

# charakterystyki filtru dla okna Kaisera z różnym β
fig6, ax6 = plt.subplots(2, sharex=True, tight_layout=True, figsize=(8, 5))
for beta in (5, 8.6, 14, 20):
    h = sig.firwin(N, 3000, window=('kaiser', beta), pass_zero='lowpass', fs=48000)
    w, hfw = sig.freqz(h, worN=2048, fs=48000)
    ax6[0].plot(w, np.abs(hfw), label=f'β={beta}')
    ax6[1].plot(w, 20 * np.log10(np.abs(hfw)), label=f'β={beta}')
ax6[0].set_ylabel('Wzmocnienie (lin)')
ax6[1].set_ylim(bottom=-220)
ax6[1].set_xlim(0, 12000)
for a in ax6:
    a.legend(loc='upper right')
    a.grid()
ax6[1].set_ylabel('Wzmocnienie [dB]')
ax6[1].set_xlabel('Częstotliwość [Hz]')
ax6[0].set_title('Charakterystyki widmowe filtru')

att = 80
width = 100 / 24000
# beta = sig.kaiser_beta(att)
nk, beta = sig.kaiserord(att, width)
print('Tłumienie -{} dB: N={} β={:.4f}'.format(att, nk, beta))

plt.show()
