"""Wykresy typów charakterystyk: DP, GP, PP, PZ."""

import numpy as np
import scipy.signal as sig
import matplotlib
import matplotlib.pyplot as plt

matplotlib.rcParams['figure.figsize'] = (8, 4)

fs = 48000
N = 101  # długość filtru

# filtr dolnoprzepustowy
fc = 3000  # częstotliwość graniczna
hdp = sig.firwin(N, fc, pass_zero='lowpass', fs=fs)

w, hfdp = sig.freqz(hdp, worN=2048, fs=fs)
# spdp = 20 * np.log10(np.abs(hfdp))
spdp = np.abs(hfdp)
plt.figure()
plt.axvline(fc, ls='--', c='k', lw=1)
plt.plot(w, spdp)
plt.xlim(0, 12000)
plt.xlabel('Częstotliwość [Hz]')
plt.ylabel('Poziom widma [dB]')
plt.title('Charakterystyka filtru dolnoprzepustowego 3 kHz (N=101)')
plt.grid()

# filtr górnoprzepustowy
hgp = sig.firwin(N, fc, pass_zero='highpass', fs=fs)

w, hfgp = sig.freqz(hgp, worN=2048, fs=fs)
# spgp = 20 * np.log10(np.abs(hfgp))
spgp = np.abs(hfgp)
plt.figure()
plt.axvline(fc, ls='--', c='k', lw=1)
plt.plot(w, spgp)
plt.xlim(0, 12000)
plt.xlabel('Częstotliwość [Hz]')
plt.ylabel('Wzmocnienie')
plt.title('Charakterystyka filtru górnoprzepustowego 3 kHz (N=101)')
plt.grid()


# filtr pasmowo-przepustowy
fd = 3000
fg = 7500
hpp = sig.firwin(N, (fd, fg), pass_zero='bandpass', fs=fs)

w, hfpp = sig.freqz(hpp, worN=2048, fs=fs)
# sppp = 20 * np.log10(np.abs(hfpp))
sppp = np.abs(hfpp)
plt.figure()
plt.axvline(fd, ls='--', c='k', lw=1)
plt.axvline(fg, ls='--', c='k', lw=1)
plt.plot(w, sppp)
plt.xlim(0, 12000)
plt.xlabel('Częstotliwość [Hz]')
plt.ylabel('Wzmocnienie')
plt.title('Charakterystyka filtru pasmowo-przepustowego 3-7,5 kHz (N=101)')
plt.grid()


# filtr pasmowo-zaporowy
hpz = sig.firwin(N, (fd, fg), pass_zero='bandstop', fs=fs)

w, hfpz = sig.freqz(hpz, worN=2048, fs=fs)
# sppz = 20 * np.log10(np.abs(hfpz))
sppz = np.abs(hfpz)
plt.figure()
plt.axvline(fd, ls='--', c='k', lw=1)
plt.axvline(fg, ls='--', c='k', lw=1)
plt.plot(w, sppz)
plt.xlim(0, 12000)
plt.xlabel('Częstotliwość [Hz]')
plt.ylabel('Wzmocnienie')
plt.title('Charakterystyka filtru pasmowo-zaporowego 3/7,5 kHz (N=101)')
plt.grid()
ylim = plt.gca().get_ylim()


# filtr pasmowo-zaporowy notch
fc = 3000
df = 100
fd = fc - df
fg = fc + df
Nn = 501
hpzn = sig.firwin(Nn, (fd, fg), pass_zero='bandstop', fs=fs)

w, hfpzn = sig.freqz(hpzn, worN=2048, fs=fs)
# sppzn = 20 * np.log10(np.abs(hfpzn))
sppzn = np.abs(hfpzn)
plt.figure()
plt.axvline(fc, ls='--', c='k', lw=1)
plt.plot(w, sppzn)
plt.xlim(0, 12000)
plt.ylim(ylim)
plt.xlabel('Częstotliwość [Hz]')
plt.ylabel('Wzmocnienie')
plt.title(f'Charakterystyka filtru pasmowo-zaporowego notch 3 kHz (N={Nn})')
plt.grid()


plt.show()
