"""Wygładzanie sygnału filtrem średniej ruchomej."""

import numpy as np
import scipy.signal as sig
import matplotlib
import matplotlib.pyplot as plt
import soundfile

matplotlib.rcParams['figure.figsize'] = (8, 4)

wav, fs = soundfile.read('distorted.wav')
wav = wav[1000:3048, 0].ravel()

noisy = np.load('noisy.npy')

t = np.arange(len(noisy)) * 256 / 48000

# oryginalny - postać czasowa
plt.figure()
plt.plot(t, noisy)
plt.xlabel('Czas [s]')
plt.ylabel('Amplituda')
plt.title('Sygnał oryginalny - postać czasowa')

# wygładzanie N = 31
kernel31 = np.ones(31) / 31
y31 = np.convolve(noisy, kernel31)[:len(noisy)]
plt.figure()
plt.plot(t, noisy, c='#c0c0c0')
plt.plot(t, y31)
plt.xlabel('Czas [s]')
plt.ylabel('Amplituda')
plt.title('Sygnał wygładzony, N=31')

# porównanie kerneli
fig3, ax3 = plt.subplots(4, figsize=(8, 6), sharex=True, tight_layout=True)
kernel5 = np.ones(5) / 5
y5 = np.convolve(noisy, kernel5)[:len(noisy)]
ax3[0].plot(t, noisy, c='#c0c0c0')
ax3[0].plot(t, y5, label='N=5')
kernel11 = np.ones(11) / 11
y11 = np.convolve(noisy, kernel11)[:len(noisy)]
ax3[1].plot(t, noisy, c='#c0c0c0')
ax3[1].plot(t, y11, label='N=11')
ax3[2].plot(t, noisy, c='#c0c0c0')
ax3[2].plot(t, y31, label="N=31")
kernel51 = np.ones(51) / 51
y51 = np.convolve(noisy, kernel51)[:len(noisy)]
ax3[3].plot(t, noisy, c='#c0c0c0')
ax3[3].plot(t, y31, label="N=51")
ax3[-1].set_xlabel('Czas [s]')
for a in ax3:
    a.set_ylabel('Ampl.')
    a.legend()

# porównanie widm kerneli
fig4, ax4 = plt.subplots(4, figsize=(8, 6), sharex=True, tight_layout=True)
w, hf5 = sig.freqz(kernel5, worN=2048, fs=48000)
ax4[0].plot(w, 20 * np.log10(np.abs(hf5)), label='N=5')
w, hf11 = sig.freqz(kernel11, worN=2048, fs=48000)
ax4[1].plot(w, 20 * np.log10(np.abs(hf11)), label='N=11')
w, hf31 = sig.freqz(kernel31, worN=2048, fs=48000)
ax4[2].plot(w, 20 * np.log10(np.abs(hf31)), label='N=31')
w, hf51 = sig.freqz(kernel51, worN=2048, fs=48000)
ax4[3].plot(w, 20 * np.log10(np.abs(hf51)), label='N=51')
ax4[-1].set_xlabel('Częstotliwość [Hz]')
for a in ax4:
    a.set_ylabel('Poziom [dB]')
    a.legend(loc='upper right')
    a.set_ylim(bottom=-70)
    a.grid()

# oryginalny - widmo
# spectrum = np.fft.rfft(wav * np.hamming(2048))
# spdb = 20 * np.log10(np.abs(spectrum))
# f = np.fft.rfftfreq(2048, 1 / 48000)
# plt.figure(figsize=(8, 4))
# plt.plot(f, spdb)
# plt.xlim(0, 12000)
# plt.ylim(bottom=0)
# plt.xlabel('Częstotliwość [Hz]')
# plt.ylabel('Poziom widma [dB]')
# plt.title('Sygnał oryginalny - postać widmowa')


plt.show()
