"""Filtracja zakłóceń z sygnału."""

import numpy as np
import scipy.signal as sig
import matplotlib
import matplotlib.pyplot as plt

matplotlib.rcParams['figure.figsize'] = (8, 4)

wav = np.load('distorted.npy')
wav = wav / np.max(np.abs(wav))
fs = 48000
t = np.arange(len(wav)) / fs

# oryginalny - postać czasowa
plt.figure()
plt.plot(t[:500], wav[:500])
plt.xlabel('Czas [s]')
plt.ylabel('Amplituda')
plt.title('Sygnał oryginalny - postać czasowa')

# oryginalny - widmo
spectrum = np.fft.rfft(wav * np.hamming(2048))
spdb = 20 * np.log10(np.abs(spectrum) / 1024)
f = np.fft.rfftfreq(2048, 1 / 48000)
plt.figure(figsize=(8, 4))
plt.plot(f, spdb)
ideal = np.zeros_like(spdb)
ideal[f > 3000] = -60
# plt.plot(f, ideal, c='r')
plt.xlim(0, 12000)
plt.ylim(bottom=-60)
plt.xlabel('Częstotliwość [Hz]')
plt.ylabel('Poziom widma [dB]')
plt.title('Sygnał oryginalny - postać widmowa')

# filtr dolnoprzepustowy
fc = 1900  # częstotliwość graniczna
N = 101  # długość filtru
h = sig.firwin(N, fc, pass_zero='lowpass', fs=48000)

# z, p, k = sig.tf2zpk(h, 1)
# print(len(z), len(p))

# odpowiedź impulsowa
plt.figure(figsize=(10, 4))
plt.stem(h, use_line_collection=True)
plt.xlabel('Indeks')
# plt.ylabel('Amplituda')
plt.title('Odpowiedź impulsowa filtru')
# plt.title('Współczynniki h')

# charakterystyka częstotliwościowa
w, hf = sig.freqz(h, worN=2048, fs=48000)
hfdb = 20 * np.log10(np.abs(hf))
plt.figure()
plt.plot(w, hfdb)
plt.xlim(0, 12000)
plt.ylim(bottom=-80)
plt.xlabel('Częstotliwość [Hz]')
plt.ylabel('Poziom widma [dB]')
plt.title('Charakterystyka częstotliwościowa')
plt.grid()

# charakterystyka częstotliwościowa + sygnał
plt.figure()
plt.plot(f, spdb)
plt.plot(w, hfdb)
plt.xlim(0, 12000)
plt.ylim(bottom=-80)
plt.xlabel('Częstotliwość [Hz]')
plt.ylabel('Poziom widma [dB]')
plt.title('Charakterystyka częstotliwościowa')
plt.grid()

# filtracja sygnału
y = sig.lfilter(h, 1, wav)
ysp = np.fft.rfft(y * np.hamming(2048))
yspdb = 20 * np.log10(np.abs(ysp) / 1024)

# widmo sygnału przed i po filtracji
plt.figure()
plt.plot(f, spdb, c='#a0a0a0', label='Oryginalny')
plt.plot(f, yspdb, label='Po filtracji')
plt.xlim(0, 12000)
# plt.ylim(bottom=0)
plt.xlabel('Częstotliwość [Hz]')
plt.ylabel('Poziom widma [dB]')
plt.legend()
plt.grid()
plt.title('Widmo sygnału przed i po filtracji')

# postać czasowa przed i po filtracji
fig7, ax7 = plt.subplots(2, figsize=(8, 5), sharex=True, tight_layout=True)
ax7[0].plot(t[:500], wav[:500], label='Originalny')
ax7[1].plot(t[:500], y[50:550], label='Przetworzony')
ax7[-1].set_xlabel('Czas [s]')
for a in ax7:
    a.set_ylabel('Amplituda')
    a.legend(loc='upper right')
ax7[0].set_title('Sygnał oryginalny i przetworzony - postać czasowa')

plt.show()
